/**
  ********************************************************************************
  *
  * @file    hal_lvd.h
  * @brief   Header file of lvd driver
  *
  * @version V1.0
  * @data    22 Aug 2018
  * @author  AE Team
  * @note
  *
  * Copyright (C) Shanghai Eastsoft Microelectronics Co. Ltd. All rights reserved.
  *
  ********************************************************************************
  */

#ifndef __HAL_LVD_H__
#define __HAL_LVD_H__

#include "hic.h"
#include "type.h"
#include "hal_base.h"

/**
  * @addtogroup ES7P203_HAL
  * @{
  */

/**
  * @addtogroup LVD
  * @{
  */

/**
  * @defgroup Lvd_Public_Enmus lvd Public Enums
  * @{
  */

/**
  * @brief LVD voltage select
  */
typedef enum {
	LVD_VOL_SEL_2_7 = 5,	/**< 2.7V */
	LVD_VOL_SEL_2_9 = 6,	/**< 2.9V */
	LVD_VOL_SEL_3_1 = 7,	/**< 3.1V */
	LVD_VOL_SEL_3_7 = 8,	/**< 3.7V */
	LVD_VOL_SEL_4_1 = 9,	/**< 4.1V */
	LVD_VOL_SEL_4_7 = 10,	/**< 4.7V */
} lvd_voltage_sel_t;

/**
  * @brief LVD trigger mode
  */
typedef enum {
	LVD_TRIGGER_RISING_EDGE		= 0,	/**< Rising edge */
	LVD_TRIGGER_FALLING_EDGE	= 1,	/**< Falling edge */
	LVD_TRIGGER_RISING_FALLING 	= 2,	/**< Rising and falling edge */
} lvd_trigger_mode_t;

/**
  * @brief LVD flag status
  */
typedef enum {
	ABOVE_THRESHOLD_VOLTAGE = 0,
	BELOW_THRESHOLD_VOLTAGE = 1,
} lvd_status_t;

/**
  * @}
  */

/**
  * @addtogroup LVD_Public_Functions
  * @{
  */

extern void lvd_init(lvd_voltage_sel_t vol, lvd_trigger_mode_t trig);
extern lvd_status_t get_lvd_status(void);

/*
  * @}
  */

/**
  * @}
  */

/**
  * @}
  */
#endif
